# Panduan Instalasi Database MikhMon Agent

Panduan ini memastikan instalasi baru memiliki seluruh tabel, kolom, dan data awal
termasuk fitur Digiflazz. Jalankan langkah secara berurutan.

## 1. Persiapan

1. Buat database MySQL/MariaDB kosong (contoh nama: `mikhmon_agents`).
2. Perbarui kredensial pada `include/db_config.php` sesuai server baru.
3. Pastikan akun DB memiliki izin `CREATE`, `ALTER`, dan `INSERT`.

## 2. Eksekusi Skrip SQL Utama

1. Jalankan `database/agent_system.sql`.
   - Membuat tabel inti (`agents`, `agent_transactions`, `agent_vouchers`, dll.).
   - Menambahkan tabel Digiflazz (`digiflazz_products`, `digiflazz_transactions`).
   - Menyisipkan `agent_settings` default termasuk kunci `digiflazz_*`.

2. Jalankan `database/complete_installation.sql`.
   - Memastikan struktur lengkap untuk hosting (kolom tambahan `public_sales`, `payment_methods`, dsb.).
   - Mengisi seed data (Tripay payment methods, profil publik, dst.)
   - Aman dijalankan berulang karena memakai `CREATE TABLE IF NOT EXISTS` dan `INSERT IGNORE`.

## 3. Tambahan / Migrasi dari Versi Lama

Jika instalasi sebelumnya belum memakai struktur baru:

- Jalankan skrip patch incremental sesuai kebutuhan:
  - `database/create_missing_tables.sql`
  - `database/fix_tables.sql`
  - `database/safe_fix_tables.sql`

Semua skrip tersebut menggunakan `CREATE TABLE IF NOT EXISTS` dan pengecekan kolom,
sehingga aman dijalankan berkali-kali.

## 4. Menggunakan Installer PHP (opsional)

Untuk otomatisasi penuh, akses via browser:

- `install_database_ultimate.php`
  - Membuat seluruh tabel + `ALTER` kolom yang hilang.
  - Mengisi data bawaan (Tripay, profil agent, pengaturan).
- `install_database.php`
  - Versi ringan untuk memastikan `agent_settings`, `payment_gateway_config`, dan `voucher_settings`.

Kedua installer aman untuk dijalankan ulang, cocok ketika provisioning otomatis.

## 5. Konfigurasi Digiflazz

Setelah tabel siap, perbarui nilai `agent_settings` berikut:

| Setting key                      | Keterangan                     |
|----------------------------------|--------------------------------|
| `digiflazz_enabled`              | Set `1` untuk mengaktifkan      |
| `digiflazz_username`             | Username Digiflazz              |
| `digiflazz_api_key`              | API key Digiflazz               |
| `digiflazz_allow_test`           | `1` bila ingin mode testing     |
| `digiflazz_default_markup_nominal` | Markup default (rupiah)      |
| `digiflazz_last_sync`            | Diisi otomatis saat sync harga  |

> Gunakan SQL `UPDATE agent_settings SET setting_value = '...' WHERE setting_key = '...'`.

## 6. Verifikasi

Setelah seluruh skrip dijalankan:

1. Cek keberadaan tabel penting:
   ```sql
   SHOW TABLES LIKE 'digiflazz_transactions';
   SHOW TABLES LIKE 'payment_methods';
   ```

2. Periksa isi dasar:
   ```sql
   SELECT COUNT(*) FROM agents;
   SELECT setting_key, setting_value FROM agent_settings WHERE setting_key LIKE 'digiflazz_%';
   SELECT COUNT(*) FROM payment_methods;
   ```

3. Untuk memastikan tidak ada kolom hilang, jalankan `DESCRIBE <nama_tabel>`.

## 7. Troubleshooting

- **Error hak akses**: Pastikan user DB memiliki izin `CREATE/ALTER`.
- **Kolom hilang setelah restore lama**: Jalankan skrip patch (`fix_tables.sql` atau installer PHP) lagi.
- **Integrasi Digiflazz tidak aktif**: Pastikan `digiflazz_enabled = 1` dan kredensial benar.
- **Curl/OpenSSL**: Server harus memiliki ekstensi PHP cURL dan OpenSSL aktif untuk call API Digiflazz.

## 8. Catatan Migrasi

- Bila memulihkan dari backup lama, jalankan skrip di atas setelah restore untuk menambah kolom/tabel baru.
- Skrip `install_database_ultimate.php` bisa dijalankan kapan saja untuk memastikan struktur tetap up-to-date tanpa menghapus data.

---
Dokumen ini berada di `docs/DATABASE_SETUP.md`. Perbarui bila ada perubahan struktur baru.
